<Material name="thin_glass_frosted" version="1.0">
    <MetaData >
        <Property formalName="Environment Map" name="uEnvironmentTexture" description="Environment texture for the material" type="Texture" filter="linear" minfilter="linearMipmapLinear" clamp="repeat" usage="environment" default="./maps/materials/spherical_checker.png" category="Material"/>
        <Property formalName="Enable Environment" name="uEnvironmentMappingEnabled" description="Enable environment mapping" type="Boolean" default="True" category="Material"/>
        <Property formalName="Baked Shadow Map" name="uBakedShadowTexture" description="Baked shadow texture for the material" type="Texture" filter="linear" minfilter="linearMipmapLinear" clamp="repeat" usage="shadow" default="./maps/materials/shadow.png" category="Material"/>
        <Property formalName="Shadow Mapping" name="uShadowMappingEnabled" description="Enable shadow mapping" type="Boolean" default="False" category="Material"/>
        <Property formalName="Fresnel Power" name="uFresnelPower" description="Fresnel power of the material" type="Float" default="1.0" category="Material"/>
        <Property formalName="Roughness" name="roughness" type="Float" min="0.000000" max="1.000000" default="1.000000" description="Roughness of the material.\n0 = fully specular\n1 = fully diffuse" category="Material"/>
        <Property formalName="Reflectivity" name="reflectivity_amount" type="Float" min="0.000000" max="1.000000" default="0.100000" description="Reflectivity factor" category="Material"/>
        <Property formalName="Glass ior" name="glass_ior" type="Float" default="1.100000" description="Index of refraction of the material" category="Material"/>
        <Property formalName="Glass Color" name="glass_color" type="Color" default="0.9 0.9 0.9" description="Color of the material" category="Material"/>
        <Property formalName="Glass Bump map" name="glass_bump" description="Additional bump map for surface" type="Texture" clamp="repeat" category="Material"/>
        <Property formalName="Glass Bump Factor" name="glass_bfactor" description="Bump map factor" default="0.0" category="Material"/>
        <Property formalName="Glass Bump Inside" name="glass_binside" description="Use bump map for internal lighting only" type="Boolean" default="False" category="Material"/>
        <Property formalName="Blur Width" name="blur_size" type="Float" default="8" min="1" max="50" description="Amount of blurring behind the glass" category="Material"/>
        <Property formalName="Gradient1D Map" description="Gradient texture of the material" hidden="True" name="randomGradient1D" type="Texture" filter="linear" minfilter="linearMipmapLinear" clamp="repeat" usage="gradient" default="./maps/materials/randomGradient1D.png"/>
        <Property formalName="Gradient2D Map" description="Gradient texture of the material" hidden="True" name="randomGradient2D" type="Texture" filter="linear" minfilter="linearMipmapLinear" clamp="repeat" usage="gradient" default="./maps/materials/randomGradient2D.png"/>
        <Property formalName="Gradient3D Map" description="Gradient texture of the material" hidden="True" name="randomGradient3D" type="Texture" filter="linear" minfilter="linearMipmapLinear" clamp="repeat" usage="gradient" default="./maps/materials/randomGradient3D.png"/>
        <Property formalName="Gradient4D Map" description="Gradient texture of the material" hidden="True" name="randomGradient4D" type="Texture" filter="linear" minfilter="linearMipmapLinear" clamp="repeat" usage="gradient" default="./maps/materials/randomGradient4D.png"/>
        <Property formalName="Refract Depth" name="refract_depth" type="Float" default="5" min="0" max="20" description="Degree of bend from refraction. Allows\ncontrol of refraction without affecting\nlighting" category="Refraction"/>
        <Property formalName="Bump Coordinates" name="bumpCoords" description="Bump coordinates of the refraction" type="Vector" default="1 1 1" category="Refraction"/>
        <Property formalName="Bump Scale" name="bumpScale" description="Scale of the bumps" type="Float" min="0.000000" max="5.000000" default="0.500000" category="Refraction"/>
        <Property formalName="Bump Bands" name="bumpBands" description="Bump bands of the refraction" type="Long" min="1.000000" max="10.000000"  default="1" category="Refraction"/>
        <Property formalName="Light Position" name="intLightPos" type="Float2" description="Position in UV space of the band-light" default="0.5 0" category="Translucent Lighting"/>
        <Property formalName="Light Color" name="intLightCol" type="Color" description="Color of the band-light" default="0.9 0.9 0.9" category="Translucent Lighting"/>
        <Property formalName="Light Brightness" name="intLightBrt" type="Float" description="Brightness of the band-light" default="0" category="Translucent Lighting"/>
        <Property formalName="Light Rotation" name="intLightRot" type="Float" description="Angle the lightsource is oriented.\nBand is perpendicular to this" default="0" min="0" max="360" category="Translucent Lighting"/>
        <Property formalName="Falloff rate" name="intLightFall" type="Float" description="Rate at which intensity drops off" default="2.0" category="Translucent Lighting"/>
    </MetaData>
    <Shaders type="GLSL" version="330">
    <Shader name="MAIN">
    <Shared>    </Shared>
<VertexShader>
        </VertexShader>
        <FragmentShader>

// add enum defines
#define mono_alpha 0
#define mono_average 1
#define mono_luminance 2
#define mono_maximum 3
#define wrap_clamp 0
#define wrap_repeat 1
#define wrap_mirrored_repeat 2
#define texture_coordinate_uvw 0
#define texture_coordinate_world 1
#define texture_coordinate_object 2
#define scatter_reflect 0
#define scatter_transmit 1
#define scatter_reflect_transmit 2

#define QT3DS_ENABLE_UV0 1
#define QT3DS_ENABLE_WORLD_POSITION 1
#define QT3DS_ENABLE_TEXTAN 1
#define QT3DS_ENABLE_BINORMAL 0

#include "vertexFragmentBase.glsllib"

// set shader output
out vec4 fragColor;

// add structure defines
struct layer_result
{
  vec4 base;
  vec4 layer;
  mat3 tanFrame;
};

// add structure defines
struct texture_coordinate_info
{
  vec3 position;
  vec3 tangent_u;
  vec3 tangent_v;
};

struct texture_return
{
  vec3 tint;
  float mono;
};

// temporary declarations
texture_coordinate_info tmp0;
texture_coordinate_info tmp1;
vec3 ftmp0;
vec3 ftmp1;
vec3 ftmp2;
vec4 tmpShadowTerm;

layer_result layers[1];

#include "SSAOCustomMaterial.glsllib"
#include "sampleLight.glsllib"
#include "sampleProbe.glsllib"
#include "sampleArea.glsllib"
#include "square.glsllib"
#include "cube.glsllib"
#include "random255.glsllib"
#include "perlinNoise.glsllib"
#include "perlinNoiseBumpTexture.glsllib"
#include "luminance.glsllib"
#include "monoChannel.glsllib"
#include "fileBumpTexture.glsllib"
#include "transformCoordinate.glsllib"
#include "rotationTranslationScale.glsllib"
#include "coordinateSource.glsllib"
#include "calculateRoughness.glsllib"
#include "evalBakedShadowMap.glsllib"
#include "evalEnvironmentMap.glsllib"
#include "microfacetBSDF.glsllib"
#include "physGlossyBSDF.glsllib"
#include "simpleGlossyBSDF.glsllib"
#include "abbeNumberIOR.glsllib"
#include "average.glsllib"
#include "perlinNoiseTexture.glsllib"
#include "fresnelLayer.glsllib"
#include "refraction.glsllib"

uniform sampler2D refractiveTexture;

bool evalTwoSided()
{
  return( false );
}

vec3 computeFrontMaterialEmissive()
{
  return( vec3( 0, 0, 0 ) );
}

void computeFrontLayerColor( in vec3 normal, in vec3 lightDir, in vec3 viewDir, in vec3 lightDiffuse, in vec3 lightSpecular, in float materialIOR, float aoFactor )
{
#if QT3DS_ENABLE_CG_LIGHTING
  layers[0].base += tmpShadowTerm * microfacetBSDF( layers[0].tanFrame, lightDir, viewDir, lightSpecular, materialIOR, roughness, roughness, scatter_reflect_transmit );

#endif
}

void computeFrontAreaColor( in int lightIdx, in vec4 lightDiffuse, in vec4 lightSpecular )
{
#if QT3DS_ENABLE_CG_LIGHTING
  layers[0].base += tmpShadowTerm * lightSpecular * sampleAreaGlossy( layers[0].tanFrame, varWorldPos, lightIdx, viewDir, roughness, roughness );

#endif
}

void computeFrontLayerEnvironment( in vec3 normal, in vec3 viewDir, float aoFactor )
{
#if !QT3DS_ENABLE_LIGHT_PROBE
  layers[0].base += tmpShadowTerm * microfacetSampledBSDF( layers[0].tanFrame, viewDir, roughness, roughness, scatter_reflect_transmit );

#else
  layers[0].base += tmpShadowTerm * sampleGlossy( layers[0].tanFrame, viewDir, roughness );

#endif
}

vec3 computeBackMaterialEmissive()
{
  return( vec3(0, 0, 0) );
}

void computeBackLayerColor( in vec3 normal, in vec3 lightDir, in vec3 viewDir, in vec3 lightDiffuse, in vec3 lightSpecular, in float materialIOR, float aoFactor )
{
#if QT3DS_ENABLE_CG_LIGHTING
  layers[0].base += vec4( 0.0, 0.0, 0.0, 1.0 );
  layers[0].layer += vec4( 0.0, 0.0, 0.0, 1.0 );
#endif
}

void computeBackAreaColor( in int lightIdx, in vec4 lightDiffuse, in vec4 lightSpecular )
{
#if QT3DS_ENABLE_CG_LIGHTING
  layers[0].base += vec4( 0.0, 0.0, 0.0, 1.0 );
  layers[0].layer += vec4( 0.0, 0.0, 0.0, 1.0 );
#endif
}

void computeBackLayerEnvironment( in vec3 normal, in vec3 viewDir, float aoFactor )
{
#if !QT3DS_ENABLE_LIGHT_PROBE
  layers[0].base += vec4( 0.0, 0.0, 0.0, 1.0 );
  layers[0].layer += vec4( 0.0, 0.0, 0.0, 1.0 );
#else
  layers[0].base += vec4( 0.0, 0.0, 0.0, 1.0 );
  layers[0].layer += vec4( 0.0, 0.0, 0.0, 1.0 );
#endif
}

float computeIOR()
{
  return( false ? 1.0 : luminance( vec3( abbeNumberIOR(glass_ior, 0.000000 ) ) ) );
}

float evalCutout()
{
  return( 1.000000 );
}

vec3 computeNormal()
{
  if ( glass_bfactor > 0.0 )
  {
    ftmp2 = fileBumpTexture(glass_bump, glass_bfactor, mono_average, tmp0, vec2( 0.000000, 1.000000 ), vec2( 0.000000, 1.000000 ), wrap_repeat, wrap_repeat, normal );
    if (!glass_binside) { normal = ftmp2; }
  }

  return( perlinNoiseBumpTexture( tmp1, bumpScale, 1.000000, false, false, 0.000000, bumpBands, false, vec3( 0.000000, 0.000000, 0.000000 ), 0.5, 0.0, 1.000000, normal ) );
}

void computeTemporaries()
{
    tmp0 = scaleCoordinate(bumpCoords, textureCoordinateInfo( texcoordTransformed_glass_bump(texCoord0), tangent, binormal ));
    tmp1 = scaleCoordinate(bumpCoords, coordinateSource(texture_coordinate_world, 0 ));
    ftmp1 = viewDir;
    ftmp0 = vec3( reflectivity_amount );
    tmpShadowTerm = evalBakedShadowMap( texCoord0 );
}

vec4 computeLayerWeights( in float alpha )
{
  vec4 color;
  color = layers[0].base * vec4( ftmp0, 1.0);
  return color;
}


void initializeLayerVariables(void)
{
  // clear layers
  layers[0].base = vec4(0.0, 0.0, 0.0, 1.0);
  layers[0].layer = vec4(0.0, 0.0, 0.0, 1.0);
  layers[0].tanFrame = orthoNormalize( tangentFrame( normal, varWorldPos ) );
}

vec3 getRefractUV( in vec2 baseUV, in vec3 normal, in float materialIOR, in float refractDepth )
{
    // Real honest-to-goodness refraction!
    vec3 refractedDir = refract( -viewDir, normal, 1.0 / materialIOR );
    float thickness = refractDepth / clamp( dot(viewDir, normal), 0.0001, 1.0 );

    // This will do an "AA" version of that loss due to critical angle and TIR
        // fakes the same effect than using the glsl refract.
    float weight = smoothstep( 0.0, 1.0, abs(dot(viewDir, normal)) * 100.0 );

    // Trace out the refracted ray and the straight view ray
    refractedDir *= thickness;
    vec3 rawDir = -viewDir * thickness;

    vec3 displace = refractedDir - rawDir;
    vec3 newUV = vec3(baseUV + displace.xy, weight);
    return newUV;
}

vec4 doFakeInnerLight( in vec3 normal, in vec3 absorb_color )
{
    vec3 lightColor = intLightCol.rgb * intLightBrt;

    float cosRot = cos(intLightRot * 0.01745329251);
    float sinRot = sin(intLightRot * 0.01745329251);
    vec2 uvDir = vec2(sinRot, cosRot);

    vec2 dvec = texCoord0.xy - intLightPos;
    float dist = dot( dvec, uvDir );
    float fallRate = log2( max( abs(intLightFall), 1.01 ) );
    vec3 fallCol = exp2( -abs(dist) * fallRate / absorb_color );

    vec3 projDir = (tangent * uvDir.x + binormal * uvDir.y) * dist * intLightFall - surfNormal * refract_depth;
    projDir = normalize(projDir);

    vec4 retVal = vec4(lightColor * fallCol, 1.0);
    retVal *= abs(dot( projDir, -ftmp2 ));
    retVal.a = pow( retVal.a, uFresnelPower );
    retVal.a *= clamp( intLightBrt * exp2(-dist * fallRate), 0.0, 1.0 );

    return retVal;
}

vec4 computeGlass(in vec3 normal, in float materialIOR, in float alpha, in vec4 color)
{
  vec4 rgba = color;
  float ratio = simpleFresnel( normal, materialIOR, uFresnelPower );
  vec3 absorb_color = ( log( glass_color.rgb ) * -1.000000 );
  // prevent log(0) -> inf number issue
  if ( isinf(absorb_color.r) ) absorb_color.r = 1.0;
  if ( isinf(absorb_color.g) ) absorb_color.g = 1.0;
  if ( isinf(absorb_color.b) ) absorb_color.b = 1.0;
  rgba.rgb *= (vec3(1.0) - absorb_color);

  vec2 texSize = vec2( textureSize( refractiveTexture, 0 ) );
  vec3 newUV = vec3((gl_FragCoord.xy * 0.5) / texSize, 0.0);
  vec4 value = texture( refractiveTexture, newUV.xy );

  newUV = getRefractUV( newUV.xy, normal, materialIOR, 0.01 * refract_depth );
  vec4 refractValue = texture( refractiveTexture, newUV.xy );

  vec3 refractColor = refractValue.a * refractValue.rgb + (1.0 - refractValue.a) * value.rgb;
  refractColor = refractColor * (vec3(1.0) - absorb_color);
  vec4 internalColor = doFakeInnerLight( normal, glass_color.rgb );
  refractColor += internalColor.rgb * internalColor.a;

  rgba = vec4(mix(refractColor, rgba.rgb, ratio), 1.0);
  return rgba;
}

        </FragmentShader>
    </Shader>
    <Shader name="NOOP">
<VertexShader>
</VertexShader>
<FragmentShader>
#define QT3DS_ENABLE_UV0 1
#define QT3DS_ENABLE_WORLD_POSITION 1
#define QT3DS_ENABLE_TEXTAN 1

vec3 texCoord0;

void main()
{

    // This is a bit silly, but the thing is that a buffer blit takes place on this
    // pass, and if you do a buffer blit on a pass that outputs to lower-resolution,
    // it only blits a smaller portion of the backbuffer that occupies that number of
    // pixels.  So we need a dummy no-op pass that is full-res in order to blit everything.
</FragmentShader>
    </Shader>
    <Shader name="PREBLUR">
<VertexShader>
</VertexShader>
<FragmentShader>
#define QT3DS_ENABLE_UV0 1
#define QT3DS_ENABLE_WORLD_POSITION 1
#define QT3DS_ENABLE_TEXTAN 1

vec3 texCoord0;

uniform sampler2D OriginBuffer;

void main()
{
    vec2 texSize = vec2( textureSize( OriginBuffer, 0 ) );
    texSize = vec2(1.0) / texSize;
    texCoord0.z = 0.0;
    texCoord0.xy = vec2(gl_FragCoord.xy * 2.0 * texSize);

    float wtSum = 0.0;
    vec4 totSum = vec4(0.0);
    for (int ix = -1; ix &lt;= 1; ++ix)
    {
       for (int iy = -1; iy &lt;= 1; ++iy)
       {
        float wt = float(ix*ix + iy*iy) * 4.0;
        wt = exp2( -wt );
        vec2 texOfs = vec2(ix, iy) * texSize;
        totSum += wt * texture( OriginBuffer, texCoord0.xy + texOfs );
        wtSum += wt;
       }
    }

    totSum /= wtSum;
    gl_FragColor = totSum;
    // No close paren because the generator adds it for us.

</FragmentShader>
    </Shader>
    <Shader name="BLURX">
<VertexShader>
</VertexShader>
<FragmentShader>
#define QT3DS_ENABLE_UV0 1
#define QT3DS_ENABLE_WORLD_POSITION 1
#define QT3DS_ENABLE_TEXTAN 1

vec3 texCoord0;

uniform sampler2D BlurBuffer;

void main()
{
    vec2 texSize = vec2( textureSize( BlurBuffer, 0 ) );
    texSize = vec2(1.0) / texSize;
    texCoord0.z = 0.0;
    texCoord0.xy = vec2(gl_FragCoord.xy * texSize);

    float sigma = clamp(blur_size * 0.5, 0.5, 100.0);
    int smpCount = int(ceil( sigma ));
    vec4 value = texture(BlurBuffer, texCoord0.xy);
    float wtsum = 1.0;
    for (int i = 1; i &lt;= smpCount; ++i)
    {
        // Base 2 Gaussian blur
        float wt = float(i) / (sigma * 0.5);
        wt = exp2( -wt*wt );
        vec2 texOfs = vec2(i, 0) * texSize;
        value += wt * texture(BlurBuffer, texCoord0.xy+texOfs);
        value += wt * texture(BlurBuffer, texCoord0.xy-texOfs);
        wtsum += wt * 2.0;
    }

    gl_FragColor = value / wtsum;
    gl_FragColor.a = 1.0;

    // No close paren because the generator adds it for us.
</FragmentShader>
    </Shader>
    <Shader name="BLURY">
<VertexShader>
</VertexShader>
<FragmentShader>
#define QT3DS_ENABLE_UV0 1
#define QT3DS_ENABLE_WORLD_POSITION 1
#define QT3DS_ENABLE_TEXTAN 1

vec3 texCoord0;

uniform sampler2D BlurBuffer;
uniform sampler2D OriginBuffer;

void main()
{
    vec2 texSize = vec2( textureSize( BlurBuffer, 0 ) );
    texSize = vec2(1.0) / texSize;
    texCoord0.z = 0.0;
    texCoord0.xy = vec2(gl_FragCoord.xy * texSize);

    float sigma = clamp(blur_size * 0.5, 0.5, 100.0);
    int smpCount = int(ceil( sigma ));
    vec4 value = texture(BlurBuffer, texCoord0.xy);

    float wtsum = 1.0;
    for (int i = 1; i &lt;= smpCount; ++i)
    {
        // Base 2 Gaussian blur
        float wt = float(i) / (sigma * 0.5);
        wt = exp2( -wt*wt );
        vec2 texOfs = vec2(0, i) * texSize;
        vec4 posValue = texture(BlurBuffer, texCoord0.xy+texOfs);
        vec4 negValue = texture(BlurBuffer, texCoord0.xy-texOfs);
        posValue = posValue.a * posValue + (1.0 - posValue.a) * texture(OriginBuffer, texCoord0.xy+texOfs);
        negValue = negValue.a * negValue + (1.0 - negValue.a) * texture(OriginBuffer, texCoord0.xy-texOfs);

        value += wt * posValue;
        value += wt * negValue;
        wtsum += wt * 2.0;
    }

    gl_FragColor = (value / wtsum);
    gl_FragColor.a = 1.0;

    // No close paren because the generator adds it for us.
</FragmentShader>
    </Shader>

    </Shaders>
<Passes >
        <ShaderKey value="20"/>
        <LayerKey count="1"/>
    <Buffer name="frame_buffer" format="source" filter="linear" wrap="clamp" size="1.0" lifetime="frame"/>
    <Buffer name="dummy_buffer" type="ubyte" format="rgba" wrap="clamp" size="1.0" lifetime="frame"/>
    <Buffer name="temp_buffer" type="fp16" format="rgba" filter="linear" wrap="clamp" size="0.5" lifetime="frame"/>
    <Buffer name="temp_blurX" type="fp16" format="rgba" filter="linear" wrap="clamp" size="0.5" lifetime="frame"/>
    <Buffer name="temp_blurY" type="fp16" format="rgba" filter="linear" wrap="clamp" size="0.5" lifetime="frame"/>
    <Pass shader="NOOP" output="dummy_buffer">
        <BufferBlit dest="frame_buffer"/>
    </Pass>
    <Pass shader="PREBLUR" output="temp_buffer">
        <BufferInput value="frame_buffer" param="OriginBuffer"/>
    </Pass>
    <Pass shader="BLURX" output="temp_blurX">
        <BufferInput value="temp_buffer" param="BlurBuffer"/>
    </Pass>
    <Pass shader="BLURY" output="temp_blurY">
        <BufferInput value="temp_blurX" param="BlurBuffer"/>
        <BufferInput value="temp_buffer" param="OriginBuffer"/>
    </Pass>
    <Pass shader="MAIN">
        <BufferInput value="temp_blurY" param="refractiveTexture"/>
        <Blending source="SrcAlpha" dest="OneMinusSrcAlpha"/>
    </Pass>
</Passes>
</Material>
